/*
 * Decompiled with CFR 0.152.
 */
package textEditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileNameExtensionFilter;

public class TextEditor
extends JFrame {
    private JTextArea textArea;
    private File file;

    public TextEditor(String title) {
        super(title);
        this.setLayout(new BorderLayout());
        this.initMenu();
        this.add((Component)this.toolBar(), "North");
        this.setSize(500, 400);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    public void initMenu() {
        this.textArea = new JTextArea();
        JMenuBar menu = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        Listener listener = new Listener();
        JMenuItem newFile = new JMenuItem();
        newFile.setText("New");
        newFile.setActionCommand("new");
        newFile.addActionListener(listener);
        fileMenu.add(newFile);
        JMenuItem openFile = new JMenuItem();
        openFile.setText("Open");
        openFile.setActionCommand("open");
        openFile.addActionListener(listener);
        fileMenu.add(openFile);
        JMenuItem saveFile = new JMenuItem();
        saveFile.setText("Save");
        saveFile.setActionCommand("save");
        saveFile.addActionListener(listener);
        fileMenu.add(saveFile);
        fileMenu.addSeparator();
        JMenuItem exit = new JMenuItem();
        exit.setText("Exit");
        exit.setActionCommand("exit");
        exit.addActionListener(listener);
        fileMenu.add(exit);
        JMenu colorChange = new JMenu("Color");
        JMenuItem blue = new JMenuItem();
        blue.setText("Blue");
        blue.setActionCommand("blue");
        blue.addActionListener(listener);
        colorChange.add(blue);
        JMenuItem green = new JMenuItem();
        green.setText("Green");
        green.setActionCommand("green");
        green.addActionListener(listener);
        colorChange.add(green);
        JMenuItem black = new JMenuItem();
        black.setText("Black");
        black.setActionCommand("black");
        black.addActionListener(listener);
        colorChange.add(black);
        JMenu background = new JMenu("BG-Color");
        JMenuItem bgBlue = new JMenuItem();
        bgBlue.setText("Blue");
        bgBlue.setActionCommand("bgBlue");
        bgBlue.addActionListener(listener);
        background.add(bgBlue);
        JMenuItem bgGreen = new JMenuItem();
        bgGreen.setText("Green");
        bgGreen.setActionCommand("bgGreen");
        bgGreen.addActionListener(listener);
        background.add(bgGreen);
        JMenuItem bgBlack = new JMenuItem();
        bgBlack.setText("Black");
        bgBlack.setActionCommand("bgBlack");
        bgBlack.addActionListener(listener);
        background.add(bgBlack);
        this.add((Component)this.textArea, "Center");
        menu.add(fileMenu);
        menu.add(colorChange);
        menu.add(background);
        this.setJMenuBar(menu);
    }

    private JToolBar toolBar() {
        JToolBar toolBar = new JToolBar();
        Listener listener = new Listener();
        JButton newFileBtn = new JButton("new");
        newFileBtn.setActionCommand("new");
        newFileBtn.addActionListener(listener);
        JButton openFileBtn = new JButton("open");
        openFileBtn.setActionCommand("open");
        openFileBtn.addActionListener(listener);
        JButton saveFileBtn = new JButton("save");
        saveFileBtn.setActionCommand("save");
        saveFileBtn.addActionListener(listener);
        toolBar.add(newFileBtn);
        toolBar.add(openFileBtn);
        toolBar.add(saveFileBtn);
        return toolBar;
    }

    private void newFile() {
        this.textArea.setText("");
    }

    private void openFile() {
        JFileChooser chooseFile = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter(null, ".txt");
        chooseFile.setFileFilter(filter);
        int returnVal = chooseFile.showOpenDialog(null);
        if (returnVal == 0) {
            this.file = chooseFile.getSelectedFile();
        }
        if (this.file != null) {
            try {
                this.textArea.read(new FileReader(this.file), null);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Could not open the file", "error", 0);
            }
        }
    }

    private void saveFile() {
        JFileChooser chooseFile = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter(null, ".txt");
        chooseFile.setFileFilter(filter);
        int returnVal = chooseFile.showSaveDialog(null);
        if (returnVal == 0) {
            this.file = chooseFile.getSelectedFile();
        }
        if (this.file != null) {
            try {
                this.textArea.write(new FileWriter(this.file));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Could not write the file", "error", 0);
            }
        }
    }

    private void exit() {
        System.exit(0);
    }

    class Listener
    implements ActionListener {
        Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("new")) {
                TextEditor.this.newFile();
            }
            if (e.getActionCommand().equals("open")) {
                TextEditor.this.openFile();
            }
            if (e.getActionCommand().equals("save")) {
                TextEditor.this.saveFile();
            }
            if (e.getActionCommand().equals("exit")) {
                TextEditor.this.exit();
            }
            if (e.getActionCommand().equals("blue")) {
                TextEditor.this.textArea.setForeground(Color.blue);
            }
            if (e.getActionCommand().equals("green")) {
                TextEditor.this.textArea.setForeground(Color.green);
            }
            if (e.getActionCommand().equals("black")) {
                TextEditor.this.textArea.setForeground(Color.black);
            }
            if (e.getActionCommand().equals("bgBlue")) {
                TextEditor.this.textArea.setBackground(Color.blue);
            }
            if (e.getActionCommand().equals("bgGreen")) {
                TextEditor.this.textArea.setBackground(Color.green);
            }
            if (e.getActionCommand().equals("bgBlack")) {
                TextEditor.this.textArea.setBackground(Color.black);
            }
        }
    }
}

