/*
 * Decompiled with CFR 0.152.
 */
package TileMapEditor;

import Main.GameArea;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;

public class Tilemap {
    GameArea gameArea;
    public int tileSize = 16;
    public int colTiles = 21;
    public int rowTiles = 21;
    public int[][] mapTileNum;

    public Tilemap(GameArea gameArea) {
        this.gameArea = gameArea;
        this.mapTileNum = new int[this.colTiles][this.rowTiles];
        this.loadMap("maps02.txt");
    }

    public void loadMap(String filePath) {
        try {
            InputStream is = this.getClass().getResourceAsStream(filePath);
            BufferedReader br = new BufferedReader(new FileReader(filePath));
            int col = 0;
            int row = 0;
            while (col < this.colTiles && row < this.rowTiles) {
                String line = br.readLine();
                while (col < this.colTiles) {
                    int num;
                    String[] numbers = line.split(" ");
                    this.mapTileNum[col][row] = num = Integer.parseInt(numbers[col]);
                    ++col;
                }
                if (col != this.colTiles) continue;
                col = 0;
                ++row;
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void draw(Graphics2D g2) {
        int col = 0;
        int row = 0;
        int x = 0;
        int y = 0;
        while (col < this.colTiles && row < this.rowTiles) {
            int tileNum = this.mapTileNum[col][row];
            g2.drawImage(this.gameArea.tileManager.getSprite(tileNum), x + 65, y + 50, this.tileSize, this.tileSize, null);
            x += this.tileSize;
            if (++col != this.colTiles) continue;
            col = 0;
            x = 0;
            ++row;
            y += this.tileSize;
        }
    }

    public void saveFile(String name, int[][] lvl) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < lvl.length) {
            int j = 0;
            while (j < lvl[i].length) {
                builder.append(String.valueOf(lvl[j][i]));
                if (j < lvl.length - 1) {
                    builder.append(" ");
                }
                ++j;
            }
            builder.append("\n");
            ++i;
        }
        String finalString = builder.toString();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(String.valueOf(name) + ".txt"));
            writer.write(finalString);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

