/*
 * Decompiled with CFR 0.152.
 */
package TileMapEditor;

import TileMapEditor.Tile;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class TileManager {
    public Tile sand;
    public Tile grass;
    public Tile water;
    public Tile potion;
    public Tile crystal;
    public Tile ring;
    public Tile wall;
    public Tile tree;
    public BufferedImage spriteSheet;
    BufferedImage img;
    public ArrayList<Tile> tiles = new ArrayList();

    public TileManager() {
        this.loadSpriteSheet();
        this.createTiles();
    }

    private void createTiles() {
        this.sand = new Tile(this.getSprite(5, 0), 0, false, false);
        this.grass = new Tile(this.getSprite(3, 0), 1, false, false);
        this.water = new Tile(this.getSprite(4, 0), 2, false, false);
        this.potion = new Tile(this.getSprite(0, 1), 3, true, false);
        this.crystal = new Tile(this.getSprite(1, 1), 4, true, false);
        this.ring = new Tile(this.getSprite(2, 1), 5, true, false);
        this.wall = new Tile(this.getSprite(1, 0), 6, false, true);
        this.tree = new Tile(this.getSprite(0, 2), 7, false, true);
        this.tiles.add(this.sand);
        this.tiles.add(this.grass);
        this.tiles.add(this.water);
        this.tiles.add(this.potion);
        this.tiles.add(this.crystal);
        this.tiles.add(this.ring);
        this.tiles.add(this.wall);
        this.tiles.add(this.tree);
    }

    public Tile getTile(int id) {
        return this.tiles.get(id);
    }

    public BufferedImage getSprite(int id) {
        return this.tiles.get(id).getSprite();
    }

    public BufferedImage getSprite(int x, int y) {
        return this.img.getSubimage(x * 16, y * 16, 16, 16);
    }

    public void loadSpriteSheet() {
        try {
            this.img = ImageIO.read(this.getClass().getResourceAsStream("/adventure_tilemap.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

