/*
 * Decompiled with CFR 0.152.
 */
package TileMapEditor;

import Main.GameArea;
import Main.GamePanel;
import TileMapEditor.BottomBar;
import TileMapEditor.Tile;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class Editing {
    public GameArea gameArea;
    public int[][] lvl;
    private Tile selectedTile;
    int objectsFound = 0;
    int objectsNum;
    public BottomBar bottomBar;
    GamePanel gamePanel;

    public Editing(GameArea gameArea) {
        this.gameArea = gameArea;
        this.loadDefaultLevel();
        this.bottomBar = new BottomBar(this);
    }

    private void loadDefaultLevel() {
        this.lvl = this.gameArea.tileMap.mapTileNum;
    }

    public GameArea getGame() {
        return this.gameArea;
    }

    public void gameStart() {
        this.gameArea.edit = true;
        this.gameArea.playGame = false;
        this.gameArea.play.objectsNum = 0;
    }

    public void render(Graphics2D g2) {
        this.gameArea.tileMap.draw(g2);
        this.bottomBar.drawSaveButton();
        this.bottomBar.drawCollectibleButtons();
        this.bottomBar.drawGroundButtons();
        this.bottomBar.drawSolidButtons();
    }

    public void drawLevel(Graphics g) {
        int tileSize = 65;
        int x = 0;
        while (x < this.lvl.length) {
            int y = 0;
            while (y < this.lvl[x].length) {
                int id = this.lvl[x][y];
                g.drawImage(this.getSprite(id), y * 16 + tileSize - 15, x * 16 + tileSize, null);
                ++y;
            }
            ++x;
        }
    }

    private BufferedImage getSprite(int spriteID) {
        return this.gameArea.tileManager.getSprite(spriteID);
    }

    public void saveLevel() {
        this.gameArea.tileMap.saveFile("maps02", this.lvl);
    }

    public void setSelectedTile(Tile tile) {
        this.selectedTile = tile;
    }

    public void changeTile(int x, int y) {
        if (this.selectedTile != null) {
            int tileX = x / 16 - 4;
            int tileY = y / 16 - 5;
            this.lvl[tileX][tileY] = this.selectedTile.getId();
        }
    }
}

