/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Main.GameArea;
import Main.PlayerMovement;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class Player {
    GameArea gameArea;
    PlayerMovement kListener;
    public JLabel player;
    public JLabel playerPic;
    public ImageIcon playerIcon;
    public int playerX = 200;
    public int playerY = 100;
    public int playerWidth = 32;
    public int playerHeight = 32;
    int playerSpeed = 4;
    public BufferedImage playerImg;
    public BufferedImage playerUp01;
    public BufferedImage playerUp02;
    public BufferedImage playerDown01;
    public BufferedImage playerDown02;
    public BufferedImage playerRight01;
    public BufferedImage playerRight02;
    public BufferedImage playerLeft01;
    public BufferedImage playerLeft02;
    int maxWidth = 680;
    int maxHeight = 360;

    public Player(GameArea gameArea, PlayerMovement kListener) {
        this.gameArea = gameArea;
        this.kListener = kListener;
        this.createPlayer();
    }

    public void createPlayer() {
        try {
            this.playerImg = ImageIO.read(this.getClass().getResourceAsStream("/palmtreeguy.png"));
            this.playerUp01 = ImageIO.read(this.getClass().getResourceAsStream("/palmtreeguy_up2.png"));
            this.playerUp02 = ImageIO.read(this.getClass().getResourceAsStream("/palmtreeguy_up3.png"));
            this.playerDown01 = ImageIO.read(this.getClass().getResourceAsStream("/palmtreeguy_down2.png"));
            this.playerDown02 = ImageIO.read(this.getClass().getResourceAsStream("/palmtreeguy_down3.png"));
            this.playerLeft01 = ImageIO.read(this.getClass().getResourceAsStream("/palmtreeguy_left02.png"));
            this.playerLeft02 = ImageIO.read(this.getClass().getResourceAsStream("/palmtreeguy_left03.png"));
            this.playerRight01 = ImageIO.read(this.getClass().getResourceAsStream("/palmtreeguy_right2.png"));
            this.playerRight02 = ImageIO.read(this.getClass().getResourceAsStream("/palmtreeguy_right3.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.playerPic = new JLabel(new ImageIcon(this.playerDown01));
    }

    public void playerMoveUpdate() {
        switch (this.kListener.playerMove) {
            case "moveUp": {
                if (this.playerY <= 50) {
                    this.playerY += 5;
                    break;
                }
                this.playerY -= this.playerSpeed;
                break;
            }
            case "moveDown": {
                if (this.playerY >= this.maxHeight) {
                    this.playerY -= 5;
                    break;
                }
                this.playerY += this.playerSpeed;
                break;
            }
            case "moveLeft": {
                if (this.playerX <= 45) {
                    this.playerX += 5;
                    break;
                }
                this.playerX -= this.playerSpeed;
                break;
            }
            case "moveRight": {
                if (this.playerX >= this.maxWidth) {
                    this.playerX -= 5;
                    break;
                }
                this.playerX += this.playerSpeed;
                break;
            }
            case "stop": {
                this.playerY += 0;
            }
        }
    }

    public void playerAnimationUpdate() {
        switch (this.kListener.playerMove) {
            case "moveUp": {
                if (this.playerImg == this.playerUp01) {
                    this.playerImg = this.playerUp02;
                    break;
                }
                this.playerImg = this.playerUp01;
                break;
            }
            case "moveDown": {
                if (this.playerImg == this.playerDown01) {
                    this.playerImg = this.playerDown02;
                    break;
                }
                this.playerImg = this.playerDown01;
                break;
            }
            case "moveRight": {
                if (this.playerImg == this.playerRight01) {
                    this.playerImg = this.playerRight02;
                    break;
                }
                this.playerImg = this.playerRight01;
                break;
            }
            case "moveLeft": {
                this.playerImg = this.playerImg == this.playerLeft01 ? this.playerLeft02 : this.playerLeft01;
            }
        }
    }

    public void drawPlayer(Graphics2D g2) {
        g2.drawImage(this.playerImg, this.playerX, this.playerY, this.playerWidth, this.playerHeight, null);
    }
}

