/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Main.Background;
import Main.GameArea;
import Main.PlayerMovement;
import TileMapEditor.Editing;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JButton;
import javax.swing.JPanel;

public class GamePanel
extends JPanel
implements Runnable {
    public JPanel imagePanel;
    public JPanel textPanel;
    public JButton buttonOne;
    public JButton buttonTwo;
    public int panelWidth = 750;
    public int panelHeight = 650;
    GameArea gameArea;
    Thread gameThread;
    PlayerMovement kListener;
    Editing editor;
    Background background = new Background(this);
    int FPS = 60;

    public GamePanel(GameArea gameArea, PlayerMovement kListener) {
        this.gameArea = gameArea;
        this.kListener = kListener;
        this.setBounds(0, 0, this.panelWidth, this.panelHeight);
        this.addKeyListener(gameArea.kListener);
        this.setFocusable(true);
        this.requestFocus();
        this.setLayout(null);
        this.background.createButtons();
    }

    public void startGameThread() {
        this.gameThread = new Thread(this);
        this.gameThread.start();
    }

    @Override
    public void run() {
        double drawInterval = 1000000000 / this.FPS;
        double delta = 0.0;
        long lastTime = System.nanoTime();
        while (this.gameThread != null) {
            long currentTime = System.nanoTime();
            delta += (double)(currentTime - lastTime) / drawInterval;
            lastTime = currentTime;
            if (!(delta >= 1.0)) continue;
            this.update();
            this.repaint();
            delta -= 1.0;
        }
    }

    public void update() {
        this.gameArea.player.playerAnimationUpdate();
        this.gameArea.player.playerMoveUpdate();
        this.gameArea.play.PlayerCollision();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.background.draw(g2);
        this.gameArea.tileMap.draw(g2);
        this.gameArea.trees.drawTrees(g2);
        if (this.gameArea.edit) {
            this.gameArea.editor.render(g2);
        }
        this.gameArea.player.drawPlayer(g2);
    }
}

