/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Main.ActionManager;
import Main.Interactions;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class GameScreen {
    Interactions interactions = new Interactions(this);
    ActionManager actionManager = new ActionManager(this);
    public JFrame frame;
    JPanel imagePanel;
    JPanel textPanel;
    JPanel inventoryPanel;
    public JLabel bgLabel;
    public JLabel titleLabel;
    public JLabel inventoryItemLabel;
    public JLabel potionItemLabel;
    public JLabel chestItemLabel;
    public JLabel crystalItemLabel;
    JButton sceneButton;
    JButton itemOneButton;
    JButton buttonOne;
    JButton buttonTwo;
    JTextArea textContent;
    String className;
    public boolean gotChest;
    public boolean gotCrystal;

    public GameScreen() {
        this.initGame();
    }

    public void initGame() {
        this.createFrame();
        this.addToFrame();
        this.frame.setVisible(true);
    }

    public void createFrame() {
        this.frame = new JFrame("Click and Point Adventure");
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setBackground(new Color(153, 204, 255));
        this.frame.setLocationRelativeTo(null);
        this.frame.setSize(700, 800);
        this.frame.setResizable(false);
        this.frame.setLayout(null);
        this.initMainGameScreen();
    }

    public void addToFrame() {
        this.frame.getContentPane().add(this.imagePanel);
        this.frame.add(this.textPanel);
        this.frame.add(this.inventoryPanel);
    }

    public void initMainGameScreen() {
        this.imagePanel = new JPanel();
        this.imagePanel.setBounds(0, 0, 700, 500);
        this.imagePanel.setBackground(new Color(153, 204, 255));
        this.imagePanel.setLayout(null);
        this.setBackgroundAndObjects();
        this.imagePanel.add(this.bgLabel);
    }

    public void setBackgroundAndObjects() {
        this.createBackground("beach-bg.png");
        this.createObjects();
        this.createTextArea("Start", "Scene01", "", "Button01", "", "Button02");
        this.createInventoryArea("potion.png", 700, 600);
    }

    public void createBackground(String bgImage) {
        this.bgLabel = new JLabel();
        this.bgLabel.setBounds(0, 0, 700, 500);
        ImageIcon bgIcon = new ImageIcon(this.getClass().getClassLoader().getResource(bgImage));
        this.bgLabel.setIcon(bgIcon);
    }

    public void createObjects() {
        this.titleLabel = new JLabel("CLICK AND POINT ADVENTURE");
        this.titleLabel.setBounds(100, 300, 600, 100);
        this.titleLabel.setForeground(Color.black);
        this.titleLabel.setFont(new Font("Comic Sans MS", 0, 30));
        this.imagePanel.add(this.titleLabel);
    }

    public void createTextArea(String buttonName, String buttonCommand, String buttonOneName, String buttonOneCommand, String buttonTwoName, String buttonTwoCommand) {
        this.textPanel = new JPanel();
        this.textPanel.setBounds(0, 500, 350, 300);
        this.textPanel.setBackground(new Color(153, 204, 255));
        this.textPanel.setLayout(null);
        this.textContent = new JTextArea();
        this.textContent.setBounds(10, 10, 300, 80);
        this.textContent.setBackground(new Color(153, 204, 255));
        this.textContent.setForeground(new Color(51, 153, 51));
        this.textContent.setEditable(false);
        this.textContent.setLineWrap(true);
        this.textContent.setWrapStyleWord(true);
        this.textContent.setFont(new Font("Comic Sans MS", 0, 20));
        this.createSceneButton(buttonName, buttonCommand);
        this.createButtons(buttonOneName, buttonOneCommand, buttonTwoName, buttonTwoCommand);
        this.textPanel.add(this.textContent);
        this.textPanel.add(this.buttonOne);
        this.textPanel.add(this.buttonTwo);
        this.textPanel.add(this.sceneButton);
    }

    public void createSceneButton(String buttonName, String buttonCommand) {
        this.sceneButton = new JButton(buttonName);
        this.sceneButton.setBounds(10, 200, 100, 50);
        this.sceneButton.setBackground(new Color(165, 229, 237));
        this.sceneButton.addActionListener(this.actionManager);
        this.sceneButton.setActionCommand(buttonCommand);
    }

    public void createButtons(String buttonOneName, String buttonOneCommand, String buttonTwoName, String buttonTwoCommand) {
        this.buttonOne = new JButton(buttonOneName);
        this.buttonOne.setBounds(10, 100, 80, 50);
        this.buttonOne.setBackground(Color.black);
        this.buttonOne.addActionListener(this.actionManager);
        this.buttonOne.setActionCommand(buttonOneCommand);
        this.buttonTwo = new JButton(buttonTwoName);
        this.buttonTwo.setBounds(100, 100, 80, 50);
        this.buttonTwo.setBackground(Color.black);
        this.buttonTwo.addActionListener(this.actionManager);
        this.buttonTwo.setActionCommand(buttonTwoCommand);
    }

    public void createInventoryArea(String inventoryItemImage, int inventoryX, int inventoryY) {
        this.inventoryPanel = new JPanel();
        this.inventoryPanel.setBounds(350, 500, 350, 300);
        this.inventoryPanel.setBackground(new Color(165, 229, 237));
        this.inventoryPanel.setLayout(new GridLayout(3, 3));
        this.createInventoryItems(inventoryItemImage, inventoryX, inventoryY);
    }

    public void createInventoryItems(String inventoryItemImage, int inventoryX, int inventoryY) {
        this.inventoryItemLabel = new JLabel();
        this.inventoryItemLabel.setBounds(inventoryX, inventoryY, 100, 100);
        ImageIcon inventoryItemIcon = new ImageIcon(this.getClass().getClassLoader().getResource(inventoryItemImage));
        this.inventoryItemLabel.setIcon(inventoryItemIcon);
        this.inventoryPanel.add(this.inventoryItemLabel);
        this.inventoryItemLabel.setVisible(false);
        System.out.println(this.getClassName());
    }

    public String getClassName() {
        this.className = this.getClass().getSimpleName();
        return this.className;
    }
}

