/*
 * Decompiled with CFR 0.152.
 */
package calculator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Calculator
extends JFrame {
    JPanel numbersPanel;
    JPanel calculatingPanel;
    JPanel resultPanel;
    JTextField inputArea;
    JButton zeroButton;
    JButton one;
    JButton two;
    JButton three;
    JButton four;
    JButton five;
    JButton six;
    JButton seven;
    JButton eight;
    JButton nine;
    JButton plus;
    JButton minus;
    JButton multiply;
    JButton divide;
    JButton equalButton;
    JButton clear;
    String operator;
    String number1;
    String number2;
    int num1;
    int num2;
    int result;

    public void restart() {
        System.out.println("restart");
        this.number1 = "";
        this.number2 = "";
        this.inputArea.setText("");
    }

    public Calculator(String title) {
        super(title);
        this.initGUI();
        this.setSize(300, 300);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    private void initGUI() {
        this.resultPanel = new JPanel();
        this.inputArea = new JTextField();
        this.inputArea.setPreferredSize(new Dimension(200, 50));
        this.inputArea.setEditable(false);
        this.resultPanel.add(this.inputArea);
        this.numbersPanel = new JPanel();
        this.zeroButton = new JButton("0");
        this.one = new JButton("1");
        this.two = new JButton("2");
        this.three = new JButton("3");
        this.four = new JButton("4");
        this.five = new JButton("5");
        this.six = new JButton("6");
        this.seven = new JButton("7");
        this.eight = new JButton("8");
        this.nine = new JButton("9");
        this.equalButton = new JButton("=");
        this.clear = new JButton("C");
        this.numbersPanel.add(this.one);
        this.numbersPanel.add(this.two);
        this.numbersPanel.add(this.three);
        this.numbersPanel.add(this.four);
        this.numbersPanel.add(this.five);
        this.numbersPanel.add(this.six);
        this.numbersPanel.add(this.seven);
        this.numbersPanel.add(this.eight);
        this.numbersPanel.add(this.nine);
        this.numbersPanel.add(this.zeroButton);
        this.numbersPanel.add(this.equalButton);
        this.numbersPanel.add(this.clear);
        this.numbersPanel.setLayout(new GridLayout(4, 4));
        this.calculatingPanel = new JPanel();
        this.plus = new JButton("+");
        this.minus = new JButton("-");
        this.multiply = new JButton("*");
        this.divide = new JButton("/");
        this.calculatingPanel.add(this.plus);
        this.calculatingPanel.add(this.minus);
        this.calculatingPanel.add(this.multiply);
        this.calculatingPanel.add(this.divide);
        this.calculatingPanel.setLayout(new GridLayout(4, 1));
        MyListener listener = new MyListener();
        this.one.addActionListener(listener);
        this.one.setActionCommand("1");
        this.two.addActionListener(listener);
        this.two.setActionCommand("2");
        this.three.setActionCommand("3");
        this.three.addActionListener(listener);
        this.four.setActionCommand("4");
        this.four.addActionListener(listener);
        this.five.setActionCommand("5");
        this.five.addActionListener(listener);
        this.six.setActionCommand("6");
        this.six.addActionListener(listener);
        this.seven.setActionCommand("7");
        this.seven.addActionListener(listener);
        this.eight.setActionCommand("8");
        this.eight.addActionListener(listener);
        this.nine.setActionCommand("9");
        this.nine.addActionListener(listener);
        this.zeroButton.setActionCommand("0");
        this.zeroButton.addActionListener(listener);
        OperatorListener oListener = new OperatorListener();
        this.equalButton.setActionCommand("=");
        this.equalButton.addActionListener(oListener);
        this.plus.setActionCommand("+");
        this.plus.addActionListener(oListener);
        this.minus.setActionCommand("-");
        this.minus.addActionListener(oListener);
        this.multiply.setActionCommand("*");
        this.multiply.addActionListener(oListener);
        this.divide.setActionCommand("/");
        this.divide.addActionListener(oListener);
        this.clear.setActionCommand("C");
        this.clear.addActionListener(oListener);
        this.setLayout(new BorderLayout(20, 15));
        this.add((Component)this.resultPanel, "North");
        this.add((Component)this.numbersPanel, "Center");
        this.add((Component)this.calculatingPanel, "East");
    }

    public void calculate() {
        this.num1 = Integer.parseInt(this.number1);
        this.num2 = Integer.parseInt(this.number2);
        switch (this.operator) {
            case "+": {
                this.add(this.num1, this.num2);
                break;
            }
            case "-": {
                this.subtract(this.num1, this.num2);
                break;
            }
            case "*": {
                this.multiply(this.num1, this.num2);
                break;
            }
            case "/": {
                this.divide(this.num1, this.num2);
            }
        }
    }

    public void add(int num1, int num2) {
        this.result = num1 + num2;
        this.inputArea.setText(Integer.toString(this.result));
    }

    public void subtract(int num1, int num2) {
        this.result = num1 - num2;
        this.inputArea.setText(Integer.toString(this.result));
    }

    public void multiply(int num1, int num2) {
        this.result = num1 * num2;
        this.inputArea.setText(Integer.toString(this.result));
    }

    public void divide(int num1, int num2) {
        this.result = num2 != 0 ? num1 / num2 : 0;
        this.inputArea.setText(Integer.toString(this.result));
    }

    class MyListener
    implements ActionListener {
        MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JButton) {
                String buttonText = ((JButton)e.getSource()).getText();
                Calculator.this.inputArea.setText(String.valueOf(Calculator.this.inputArea.getText()) + buttonText);
            }
        }
    }

    class OperatorListener
    implements ActionListener {
        OperatorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("+") || e.getActionCommand().equals("-") || e.getActionCommand().equals("*") || e.getActionCommand().equals("/")) {
                Calculator.this.number1 = Calculator.this.inputArea.getText();
                Calculator.this.inputArea.setText("");
            }
            if (e.getActionCommand().equals("=")) {
                Calculator.this.number2 = Calculator.this.inputArea.getText();
                Calculator.this.calculate();
            }
            if (e.getActionCommand().equals("+")) {
                Calculator.this.operator = "+";
            }
            if (e.getActionCommand().equals("-")) {
                Calculator.this.operator = "-";
            }
            if (e.getActionCommand().equals("*")) {
                Calculator.this.operator = "*";
            }
            if (e.getActionCommand().equals("/")) {
                Calculator.this.operator = "/";
            }
            if (e.getActionCommand().equals("C")) {
                Calculator.this.restart();
            }
        }
    }
}

